<?php
/**
 * Report Requiremetns Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Rep_stocks extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Logs_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Stok';
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/rep_stocks/index', $data);
	}

	public function get_data_detail()
	{	
		$item       = $this->input->post("item");
		$date_start = $this->input->post("date_start");
		$date_end   = $this->input->post("date_end");

        $data  = [];
        $where = [];

        if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['log_item_id'] = $item;
		}
		if(isset($date_start) && $date_start != '')
		{
			$where['a.batch_header_start >='] = change_format_date($date_start);
		}
		if(isset($date_end) && $date_end != '')
		{
			$where['a.batch_header_start <='] = change_format_date($date_end);
        }
        
		$get_data = $this->Logs_model->get_data_advance()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
                $therest   = $get_row->log_total_stock;

                $total_large  = ($get_row->log_large_unit_contain == 0 ? 0 : floor($get_row->log_total_stock / $get_row->log_large_unit_contain));

                $therest   = ($get_row->log_total_stock - ($total_large * $get_row->log_large_unit_contain));
                $total_medium = ($get_row->log_medium_unit_contain == 0 ? 0 : floor($therest / $get_row->log_medium_unit_contain));

                $therest = ($get_row->log_total_stock - ($total_medium * $get_row->log_medium_unit_contain));
                $total_small = ($get_row->log_small_unit_contain == 0 ? 0 : floor($therest / $get_row->log_small_unit_contain));

                $lg_unit = $total_large ." ". $get_row->log_large_unit;
                $md_unit = $total_medium ." ". $get_row->log_medium_unit;
                $sm_unit = $total_small ." ". $get_row->log_small_unit;
				$data[] = array(
					'no'          => $no,
					'item_name'   => $get_row->item_name,
					'large_unit'  => $therest,
					'medium_unit' => 0,
					'small_unit'  => 0
				);
                $no++;
                
			}
		}
		// $this->session->set_userdata('status', $status);

		output_json($data);
	}

	public function export_excel() {

		$status   = $this->session->userdata('status');
		// $get_data = $this->Reports_model->get_requirements_detail($status)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('LOOP INDONESIA')
							   ->setLastModifiedBy('LOOP INDONESIA')
							   ->setTitle("PERSYARATAN")
							   ->setSubject("PERSYARATAN")
							   ->setDescription("PERSYARATAN")
							   ->setKeywords("PERSYARATAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "PERSYARATAN");
	    $excel->getActiveSheet()->mergeCells('A1:E1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$text_status = ($status == 1 ? "Paling banyak memenuhi persyaratan" : "Paling banyak tidak memenuhi persyaratan");

	    $excel->setActiveSheetIndex(0)->setCellValue('A3', "Status");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$text_status);
		
	    $excel->setActiveSheetIndex(0)->setCellValue('A5', "No");
	    $excel->setActiveSheetIndex(0)->setCellValue('B5', "Kode");
	    $excel->setActiveSheetIndex(0)->setCellValue('C5', "Persyaratan");
	    $excel->setActiveSheetIndex(0)->setCellValue('D5', "Keterangan");
	    $excel->setActiveSheetIndex(0)->setCellValue('E5', "Info");

	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E5')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 6; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $row){ // Lakukan looping pada variabel row
			
			$info   = ($status == 1 ? "Peserta telah menyelesaikan syarat ini" : "Peserta belum menyelesaikan syarat ini");
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $row->requirement_code);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $row->batch_detail_requirement_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $row->requirement_description);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $row->cnt." ".$info);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
	    	$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		 }
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PERSYARATAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PERSYARATAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
